#include "configdata.h"
#include <io.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

configdata::configdata()
{
	first_clan = new clan_t;
	first_clan->next = 0;
	last_clan = first_clan;
	current_clan = first_clan;
	first_weapon = new weapon_t;
	first_weapon->next = 0;
	last_weapon = first_weapon;
	current_weapon = first_weapon;
	first_deathtype = new deathtype_t;
	first_deathtype->next = 0;
	last_deathtype = first_deathtype;
	current_deathtype = first_deathtype;
	clan_count = 0;
	weapon_count = 0;
	deathtype_count = 0;
	first_Q2_msg = new killtext_t*[msgtype_count];
	last_Q2_msg = new killtext_t*[msgtype_count];
	first_QW_msg = new killtext_t*[msgtype_count];
	last_QW_msg = new killtext_t*[msgtype_count];
	for (int type = 0; type < msgtype_count; type++) {
		first_Q2_msg[type] = new killtext_t[1];
		first_Q2_msg[type]->next = 0;
		last_Q2_msg[type] = first_Q2_msg[type];
		first_QW_msg[type] = new killtext_t[1];
		first_QW_msg[type]->next = 0;
		last_QW_msg[type] = first_QW_msg[type];
	}
	strcpy (htmlfile, "result.htm");
	centerprint = true;
	temp_output = false;
	single = false;
	weaponkills = false;
	write_idda_log = false;
	write_console_log = false;
	write_console_log_html = false;
	write_kills_per_time_graph = false;
	write_ways_and_kills_graph = false;
	write_graph = false;
	graph_all_clients = false;
	open_all = false;
	open_graphs = false;
	open_results = false;
	open_logs = false;
	dont_del_nps = false;
	html = false;
	onehtml = false;
	userconfig = false;
	no_claninfo = false;
	no_killcharts = false;
	is_lmctf = false;
	is_battle = false;
	no_times = false;
	kills_by_weapons = 0;
	top_x_players = 0;
	gametype = gt_none;
	strcpy (html_open_command, "start %");
	sortorder_players[0] = so_ratio;
	sortorder_players[1] = so_name;
}

configdata::~configdata()
{
	if (weapon_count > 0) {
		for (int i = 0; i < weapon_count; i++) {
			delete[] weapons[i].name;
		}
		delete[] weapons;
	}
	if (clan_count > 0) {
		for (int i = 0; i < clan_count; i++) {
			delete[] clans[i].name;
			clan_id_t* current = clans[i].ids->next;
			while (current != 0) {
				clan_id_t* temp = current->next;
				delete[] current->id;
				delete[] current;
				current = temp;
			}
			delete[] clans[i].ids;
		}
		delete[] clans;
	}
	if (deathtype_count > 0) {
		for (int i = 0; i < deathtype_count; i++) {
			delete[] deathtypes[i].name;
		}
		delete[] deathtypes;
	}
	delete[] buf;
	for (int type = 0; type < msgtype_count; type++) {
		killtext_t* current = first_Q2_msg[type]->next;
		while (current != 0) {
			killtext_t* temp = current->next;
			delete[] current->text;
			delete[] current;
			current = temp;
		}
		delete[] first_Q2_msg[type];
		current = first_QW_msg[type]->next;
		while (current != 0) {
			killtext_t* temp = current->next;
			delete[] current->text;
			delete[] current;
			current = temp;
		}
		delete[] first_QW_msg[type];
	}
	delete[] first_Q2_msg;
	delete[] last_Q2_msg;
	delete[] first_QW_msg;
	delete[] last_QW_msg;
}

void configdata::add_weapon(weapon_t* weapon)
{
	last_weapon->next = new weapon_t;
	last_weapon = last_weapon->next;
	last_weapon->name = new char[strlen(weapon->name)+1];
	strcpy (last_weapon->name, weapon->name);
	last_weapon->number = weapon->number;
	last_weapon->next = 0;
	weapon_count++;
}

void configdata::add_deathtype(deathtype_t* deathtype)
{
	last_deathtype->next = new deathtype_t;
	last_deathtype = last_deathtype->next;
	last_deathtype->name = new char[strlen(deathtype->name)+1];
	strcpy (last_deathtype->name, deathtype->name);
	last_deathtype->number = deathtype->number;
	last_deathtype->next = 0;
	deathtype_count++;
}

void configdata::add(killtext_t** x, char* killtext, int weapon)
{
	(*x)->next = new killtext_t[1];
	(*x) = (*x)->next;
	(*x)->next = 0;
	(*x)->text = new char[strlen(killtext)+1];
	strcpy ((*x)->text, killtext);
	(*x)->weapon = weapon;
}

void configdata::read_configfile(char* pathstr)
{
	printf ("\nReading config file"); // DEV
	int configfile;
	configfile = _open (pathstr, _O_BINARY);
	if (configfile == -1) err->msg_and_exit ("Couldn't read configfile (%s)!", pathstr);
	buflen = _filelength (configfile);
	buf = new char[buflen];
	_read (configfile, buf, buflen);
	_close (configfile);
	parse_data ();
}

void configdata::search_option(char* kstr, option_t type, ...) 
{
	va_list arglist;
	va_start (arglist, type);
	killtext_t** kdata = 0;
	int pos = 0;
	for (;;) {
		pos = misc->find_sub (pos, buf, buflen, kstr, strlen (kstr));
		if (pos == -1) break;
		char clan_name[256];
		char clan_id[256];
		switch (type) {
		case kill:
			if (kdata == 0) {
				kdata = va_arg (arglist, killtext_t**);
				if (kdata == 0) {
					err->msg_and_exit ("search_option: no nullpointer allowed!");
				}
			}
			add (kdata, read_string(buf, pos), read_int(buf, pos));
			break;
		case weapon:
			weapon_t weapon;
			weapon.number = read_int(buf, pos);
			weapon.name = read_string(buf, pos);
			weapon.next = 0;
			add_weapon (&weapon);
			break;
		case clan:
			strcpy (clan_name, read_string(buf, pos));
			strcpy (clan_id, read_string(buf, pos));
			add_clan_id (clan_name, clan_id);
			break;
		case deathtype:
			deathtype_t deathtype;
			deathtype.number = read_int(buf, pos);
			deathtype.name = read_string(buf, pos);
			deathtype.next = 0;
			add_deathtype (&deathtype);
			break;
		case html_open:
			strcpy (html_open_command, read_string(buf, pos));
			break;
		default:
			break;
		}
	}
	va_end (arglist);
}

void configdata::parse_data()
{
	printf ("\nParsing config data"); // DEV
	search_option ("html_open", html_open);
	search_option ("clan_t", clan);
	search_option ("weapon_t", weapon);
	search_option ("death_t", deathtype);
	search_option ("Q2_y_kills_x", kill, &last_Q2_msg[y_kills_x]);
	search_option ("Q2_x_kills_y", kill, &last_Q2_msg[x_kills_y]);
	search_option ("Q2_selfkill", kill, &last_Q2_msg[selfkill]);
	search_option ("Q2_death", kill, &last_Q2_msg[death]);
	search_option ("Q2_extra_frags", kill, &last_Q2_msg[extra_frags]);
	search_option ("Q2_flag_capture", kill, &last_Q2_msg[flag_captures]);
	search_option ("Q2_ctf_assist", kill, &last_Q2_msg[ctf_assists]);
	search_option ("Q2_ctf_helped_return", kill, &last_Q2_msg[ctf_helped_return]);
	search_option ("Q2_flag_stolen", kill, &last_Q2_msg[flag_stolen]);
	search_option ("Q2_flag_loss", kill, &last_Q2_msg[flag_losses]);
	search_option ("Q2_ctf_defend_flag", kill, &last_Q2_msg[ctf_defend_flag]);
	search_option ("Q2_ctf_defend_base", kill, &last_Q2_msg[ctf_defend_base]);
	search_option ("Q2_ctf_defend_flagcarrier", kill, &last_Q2_msg[ctf_defend_flagcarrier]);
	search_option ("Q2_ctf_defend_aggressive", kill, &last_Q2_msg[ctf_defend_aggressive]);
	search_option ("Q2_flag_return", kill, &last_Q2_msg[flag_return]);
	search_option ("Q2_flagcarrier_frag", kill, &last_Q2_msg[flagcarrier_frag]);
	search_option ("QW_y_kills_x", kill, &last_QW_msg[y_kills_x]);
	search_option ("QW_x_kills_y", kill, &last_QW_msg[x_kills_y]);
	search_option ("QW_selfkill", kill, &last_QW_msg[selfkill]);
	search_option ("QW_death", kill, &last_QW_msg[death]);
	search_option ("QW_extra_frags", kill, &last_QW_msg[extra_frags]);
	search_option ("QW_flag_capture", kill, &last_QW_msg[flag_captures]);
	search_option ("QW_ctf_assist", kill, &last_QW_msg[ctf_assists]);
	search_option ("QW_ctf_helped_return", kill, &last_QW_msg[ctf_helped_return]);
	search_option ("QW_flag_stolen", kill, &last_QW_msg[flag_stolen]);
	search_option ("QW_flag_loss", kill, &last_QW_msg[flag_losses]);
	search_option ("QW_ctf_defend_flag", kill, &last_QW_msg[ctf_defend_flag]);
	search_option ("QW_ctf_defend_base", kill, &last_QW_msg[ctf_defend_base]);
	search_option ("QW_ctf_defend_flagcarrier", kill, &last_QW_msg[ctf_defend_flagcarrier]);
	search_option ("QW_ctf_defend_aggressive", kill, &last_QW_msg[ctf_defend_aggressive]);
	search_option ("QW_flag_return", kill, &last_QW_msg[flag_return]);
	search_option ("QW_flagcarrier_frag", kill, &last_QW_msg[flagcarrier_frag]);
	printf ("\nParsing clan data");
	parse_clan_data();
	printf ("\nParsing weapon data");
	parse_weapon_data();
	printf ("\nParsing deathtype data");
	parse_deathtype_data();
}

void configdata::parse_clan_data()
{
	int count = 0;
	if (clan_count == 0) {
		return;
	}
	clans = new clan_t[clan_count];
	clan_t* temp = first_clan;
	while (temp->next != 0) {
		temp = temp->next;
		clans[count].name = new char[strlen(temp->name)+1];
		strcpy (clans[count].name, temp->name);
		clan_id_t* temp_ids = temp->ids;
		clans[count].ids = new clan_id_t[1];
		clan_id_t* ids = clans[count].ids;
		while (temp_ids->next != 0) {
			temp_ids = temp_ids->next;
			ids->next = new clan_id_t[1];
			ids = ids->next;
			ids->next = 0;
			ids->id = new char[strlen(temp_ids->id)+1];
			strcpy (ids->id, temp_ids->id);
		}
		count++;
	}
	current_clan = first_clan->next;
	for (;;) {
		temp = current_clan->next;
		clan_id_t* current_clan_id = current_clan->ids->next;
		for (;;) {
			clan_id_t* temp_id = current_clan_id->next;
			delete[] current_clan_id->id;
			delete[] current_clan_id;
			if (temp_id == 0) break;
			current_clan_id = temp_id;
		}
		delete[] current_clan->ids;
		delete[] current_clan->name;
		delete[] current_clan;
		if (temp == 0) break;
		current_clan = temp;
	}
	delete[] first_clan;
}

void configdata::parse_weapon_data()
{
	if (weapon_count == 0) {
		return;
	}
	weapons = new weapon_t[weapon_count];
	weapon_t* temp = first_weapon;
	while (temp->next != 0) {
		temp = temp->next;
		if (temp->number >= weapon_count) {
			err->msg_and_exit ("Illegal weapon number in cfg!");
		}
		weapons[temp->number].name = new char[strlen(temp->name)+1];
		strcpy (weapons[temp->number].name, temp->name);
	}
	current_weapon = first_weapon->next;
	for (;;) {
		temp = current_weapon->next;
		delete[] current_weapon->name;
		delete[] current_weapon;
		if (temp == 0) break;
		current_weapon = temp;
	}
	delete[] first_weapon;
}

void configdata::parse_deathtype_data()
{
	if (deathtype_count == 0) {
		return;
	}
	deathtypes = new deathtype_t[deathtype_count];
	deathtype_t* temp = first_deathtype;
	while (temp->next != 0) {
		temp = temp->next;
		if (temp->number >= deathtype_count) {
			err->msg_and_exit ("Illegal deathtype number in cfg!");
		}
		deathtypes[temp->number].name = new char[strlen(temp->name)+1];
		strcpy (deathtypes[temp->number].name, temp->name);
	}
	current_deathtype = first_deathtype->next;
	for (;;) {
		temp = current_deathtype->next;
		delete[] current_deathtype->name;
		delete[] current_deathtype;
		if (temp == 0) break;
		current_deathtype = temp;
	}
	delete[] first_deathtype;
}

clan_t* configdata::get_clan(int num)
{
	return &clans[num];
}

weapon_t* configdata::get_weapon(int num)
{
	return &weapons[num];
}

deathtype_t* configdata::get_deathtype(int num)
{
	return &deathtypes[num];
}

int configdata::get_clan_count()
{
	return clan_count;
}

int configdata::get_weapon_count ()
{
	return weapon_count;
}

int configdata::get_deathtype_count ()
{
	return deathtype_count;
}

killtext_t* configdata::get_first_Q2_msg (int type)
{
	return first_Q2_msg[type]->next;
}

killtext_t* configdata::get_first_QW_msg (int type)
{
	return first_QW_msg[type]->next;
}

void configdata::read_options(int argc, char **argv)
{
    int i, j;  
	char tempstr[256];
    if (argv[1][0] == '/') {
		err->msg_and_exit ("First parameter must be filename (with or without wildcards)!");
	}
    for (i = 2; i < argc; i++) { 
		strcpy (tempstr, argv[i]);
		_strupr (tempstr);
        if ((tempstr[0] == '-') || (tempstr[0] == '/')) { 
			switch (tempstr[1]) {
			case 'B':
				kills_by_weapons = atoi (tempstr+2);
				break;
			case 'T':
				if (strstr (tempstr+1, "TEMP") == 0) {
					top_x_players = atoi (tempstr+2);
				} else {
					temp_output = true;
				}
				break;
			case 'N':
				switch (tempstr[2]) {
				case 'C':
					no_claninfo = true;
					break;
				case 'Z':
					centerprint = false;
					break;
				case 'K':
					no_killcharts = true;
					break;
				default:
					break;
				}
				break;
			case 'S':
				single = true;
				break;
			case 'W':
				weaponkills = true;
				break;
			case 'L':
				for (j = 2; j < strlen(tempstr); j++) {
					switch (tempstr[j]) {
					case 'I': 
						write_idda_log = true;
						break;
					case 'C': 
						write_console_log = true;
						break;
					case 'H': 
						write_console_log_html = true;
						break;
					default:
						break;
					}
				}
				break;
			case 'A':
				if (tempstr[2] == 0) {
					open_all = true;
				} else {
					for (j = 2; j < strlen(tempstr); j++) {
						switch (tempstr[j]) {
						case 'G':
							open_graphs = true;
							break;
						case 'H':
							open_results = true;
							break;
						case 'L':
							open_logs = true;
							break;
						}
					}
				}
				break;
			case 'D':
				dont_del_nps = true;
				break;
			case 'G':
				for (j = 2; j < strlen(tempstr); j++) {
					switch (tempstr[j]) {
					case 'T':
						write_kills_per_time_graph = true;
						write_graph = true;
						break;
					case 'K':
						write_ways_and_kills_graph = true;
						write_graph = true;
						break;
					case '+':
						graph_all_clients = true;
						write_graph = true;
						break;
					}
				}
				break;
			case 'H':
				html = true;
                if (tempstr[2] == ':') {
                    strcpy (htmlfile, tempstr+3);
                    onehtml = true;
                }
				break;
			case 'C':
				userconfig = true;
                if (tempstr[2] == ':') {
                    strcpy (userconfigfile, tempstr+3);
                }
				break;
			case 'O':
				for (j = 0; j < 2; j++) {
					switch (tempstr[2+j]) {
					case 'S':
						sortorder_players[j] = so_skill;
						break;
					case 'C':
						sortorder_players[j] = so_clan;
						break;
					case 'N':
						sortorder_players[j] = so_name;
						break;
					case 'F':
						sortorder_players[j] = so_frags;
						break;
					case 'K':
						sortorder_players[j] = so_kills;
						break;
					case 'R':
						sortorder_players[j] = so_ratio;
						break;
					case 'T':
						sortorder_players[j] = so_team;
						break;
					case '1':
						sortorder_players[j] = so_fph;
						break;
					case '2':
						sortorder_players[j] = so_kph;
						break;
					default:
						break;
					}
				}
				break;
			default:
				break;
			}
        }
    }
}

void configdata::get_configpath (char* configpath, char* execstr)
{
	configpath[0] = 0;
	if (strlen (execstr) > 1) {
		strcpy (configpath, execstr);
	}
	int i = strlen (execstr) - 1;
	while ((configpath[--i] != '\\') && (i > 0)) {
		configpath[i] = 0;
	}
	i = strlen (configpath) - 1;
	strcat (configpath, "idda1.cfg");
	char* pos = strstr (configpath, "iidda1.cfg");
	if (pos > configpath) {
		printf ("\nWarning: NT cfg pathstring bug autofixed\n\n");
		strcpy (pos, "idda1.cfg");
	}
}


char* configdata::get_temppath () 
{
	static char tempdir[256];
	strcpy (tempdir, getenv ("TEMP"));
	if (tempdir == 0) strcpy (tempdir, getenv ("TMP"));
	if (tempdir != 0) {
		if (tempdir[strlen(tempdir)] != '\\') {
			strcat (tempdir, "\\");
		}
	}
	return tempdir;
}

char* configdata::read_string(char* buf, int& pos)
{
	static char str[256];
	int a = pos;
	while ((buf[a] != '\"') && (++a < buflen));
	a++;
	int b = a;
	while ((buf[b] != '\"') && (++b < buflen));
	if (b-a > 255) {
		err->msg_and_exit ("Too long string in configfile!");
	}
	strncpy (str, buf+a, b-a);
	str[b-a] = 0;
	pos = b+1;
	return str;
}

int configdata::read_int(char* buf, int& pos)
{
	int number;
	int a = pos;
	while (((buf[a] == ' ') || (buf[a] == '\x09')) && (++a < buflen));
	int b = a;
	while (((buf[b] != ' ') && (buf[b] != '\x09')) && (++b < buflen));
	char* tempstr = new char[b-a+1];
	strncpy (tempstr, buf+a, b-a);
	tempstr[b-a] = 0;
	number = atoi (tempstr);
	pos = b;
	delete[] tempstr;
	return number;
}

char* configdata::get_open_command(char* filename)
{
	static char command[260];
	for (int i = 0; i < 260; i++) {
		command[i] = 0;
	}
	int pos = misc->find_sub (0, html_open_command, strlen (html_open_command), "%", 1);
	if (pos == -1) {
		err->msg_and_exit ("configdata::get_open_command: where to put filespec (\"%%\")?");
	}
	strncpy (command, html_open_command, pos-1);
	strcat (command, filename);
	strcat (command, html_open_command+pos);
	return command;
}


void configdata::add_clan_id(char *name, char *id)
{	
	current_clan = first_clan->next;
	while ((current_clan != 0) && (strcmp (name, current_clan->name) != 0)) {
		current_clan = current_clan->next;
	}
	if (current_clan == 0) {
		last_clan->next = new clan_t[1];
		last_clan = last_clan->next;
		last_clan->ids = new clan_id_t[1];
		last_clan->ids->next = 0;
		last_clan->next = 0;
		current_clan = last_clan;
		current_clan->name = new char[strlen(name)+1];
		strcpy (current_clan->name, name);
		clan_count++;
	}
	clan_id_t* temp = current_clan->ids;
	while (temp->next != 0) {
		temp = temp->next;
	}
	temp->next = new clan_id_t[1];
	temp->next->next = 0;
	temp->next->id = new char[strlen(id)+1];
	strcpy (temp->next->id, id);
}

